package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;
import java.util.Date;

/**
 * User: Rob Murtha
 */
public class DataLoadResponse implements Serializable {
    
    private static final long serialVersionUID = 4176970672941523874L;
    private String icn;
    private String stationNumber;
    private String extractType;
    private Date startDate;
    private Date endDate;
    private long requestMsgCtrlId;
    private long responseMsgCtrlId;
    private long recordCount;

    public DataLoadResponse(
            String icn,
            String stationNumber,
            String extractType,
            Date startDate,
            Date endDate,
            long requestMsgCtrlId,
            long responseMsgCtrlId,
            long recordCount){
        this.icn = icn;
        this.stationNumber=stationNumber;
        this.extractType=extractType;
        this.startDate=startDate;
        this.endDate=endDate;
        this.requestMsgCtrlId = requestMsgCtrlId;
        this.responseMsgCtrlId = responseMsgCtrlId;
        this.recordCount=recordCount;
    }

    public String getIcn() {
        return icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public long getRequestMsgCtrlId() {
        return requestMsgCtrlId;
    }

    public void setRequestMsgCtrlId(long requestMsgCtrlId) {
        this.requestMsgCtrlId = requestMsgCtrlId;
    }

    public long getResponseMsgCtrlId() {
        return responseMsgCtrlId;
    }

    public void setResponseMsgCtrlId(long responseMsgCtrlId) {
        this.responseMsgCtrlId = responseMsgCtrlId;
    }

    public String getExtractType() {
        return extractType;
    }

    public void setExtractType(String extractType) {
        this.extractType = extractType;
    }

    public long getRecordCount() {
        return recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DataLoadResponse)) return false;

        DataLoadResponse that = (DataLoadResponse) o;

        if (recordCount != that.recordCount) return false;
        if (requestMsgCtrlId != that.requestMsgCtrlId) return false;
        if (responseMsgCtrlId != that.responseMsgCtrlId) return false;
        if (endDate != null ? !endDate.equals(that.endDate) : that.endDate != null) return false;
        if (extractType != null ? !extractType.equals(that.extractType) : that.extractType != null) return false;
        if (icn != null ? !icn.equals(that.icn) : that.icn != null) return false;
        if (startDate != null ? !startDate.equals(that.startDate) : that.startDate != null) return false;
        if (stationNumber != null ? !stationNumber.equals(that.stationNumber) : that.stationNumber != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = (icn != null ? icn.hashCode() : 0);
        result = 31 * result + (stationNumber != null ? stationNumber.hashCode() : 0);
        result = 31 * result + (extractType != null ? extractType.hashCode() : 0);
        result = 31 * result + (startDate != null ? startDate.hashCode() : 0);
        result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
        result = 31 * result + (int) (requestMsgCtrlId ^ (requestMsgCtrlId >>> 32));
        result = 31 * result + (int) (responseMsgCtrlId ^ (responseMsgCtrlId >>> 32));
        result = 31 * result + (int) (recordCount ^ (recordCount >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "DataLoadResponse{" +
                "icn='" + icn + '\'' +
                ", stationNumber='" + stationNumber + '\'' +
                ", extractType='" + extractType + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", requestMsgCtrlId=" + requestMsgCtrlId +
                ", responseMsgCtrlId=" + responseMsgCtrlId +
                ", recordCount=" + recordCount +
                '}';
    }
}
